local STRINGS = GLOBAL.STRINGS
local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
GetPlayer = GLOBAL.GetPlayer
STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
SpawnPrefab = GLOBAL.SpawnPrefab


PrefabFiles = {
"armor_sanity",
"nightsword",
"nightmare_bush",
"dug_nightmare_bush",
"nightmaretools",
"nightmarebrick",
"nightmarewall",
"nightmarehelmet",
"nightmaremech",
"shadowcreature",
"nightmarecreature",
"warlock_ball",
"nightmarefissure",
"nightmarelight",
"statueruins",
}

Assets = {

	Asset( "ANIM", "anim/creepyman.zip" ),
	Asset( "ANIM", "anim/shadowbug.zip" ),
	Asset( "ANIM", "anim/wickedwarlock.zip" ),
	Asset( "ANIM", "anim/wretchedrock.zip" ),

	Asset( "ANIM", "anim/nightmarebrick.zip" ),
	
	Asset( "IMAGE", "minimap/nightmarebush.tex" ),
	Asset( "ATLAS", "minimap/nightmarebush.xml" ),
	
	Asset( "ANIM", "anim/nightmareaxe.zip" ),
	Asset( "ANIM", "anim/swap_nightmareaxe.zip" ),
	
	Asset( "ANIM", "anim/nightmarehammer.zip" ),
	Asset( "ANIM", "anim/swap_nightmarehammer.zip" ),
	
	Asset( "ANIM", "anim/nightmarepickaxe.zip" ),
	Asset( "ANIM", "anim/swap_nightmarepickaxe.zip" ),
	
	Asset( "ANIM", "anim/nightmareshovel.zip" ),
	Asset( "ANIM", "anim/swap_nightmareshovel.zip" ),
	
	Asset( "IMAGE", "images/inventoryimages/shadowtab.tex" ),
	Asset( "ATLAS", "images/inventoryimages/shadowtab.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/dug_nightmare_bush.tex" ),
	Asset( "ATLAS", "images/inventoryimages/dug_nightmare_bush.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmareaxe.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmareaxe.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmarehammer.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmarehammer.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmarepickaxe.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmarepickaxe.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmareshovel.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmareshovel.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmarebrick.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmarebrick.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/nightmarehelmet.tex" ),
	Asset( "ATLAS", "images/inventoryimages/nightmarehelmet.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/wall_nightmare_item.tex" ),
	Asset( "ATLAS", "images/inventoryimages/wall_nightmare_item.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/mech_nightmare_item.tex" ),
	Asset( "ATLAS", "images/inventoryimages/mech_nightmare_item.xml" ),
	
	     }
 
AddMinimapAtlas("minimap/nightmarebush.xml")

	STRINGS.TABS.SHADOWTAB = "Nightmares"
	GLOBAL.RECIPETABS['SHADOWTAB'] = {str = "SHADOWTAB", sort=9, icon = "shadowtab.tex", icon_atlas = "images/inventoryimages/shadowtab.xml"}
	
	local nightmarebrick = Ingredient( "nightmarebrick", 1)
		nightmarebrick.atlas = "images/inventoryimages/nightmarebrick.xml"
		
	local nightmarebrickthree = Ingredient( "nightmarebrick", 3)
		nightmarebrickthree.atlas = "images/inventoryimages/nightmarebrick.xml"
		
	local nightmarewall = Ingredient("wall_nightmare_item", 1)
		nightmarewall.atlas = "images/inventoryimages/wall_nightmare_item.xml"

	local nightmarfuelrecipe = GLOBAL.Recipe( ("nightmarefuel"), {Ingredient("petals_evil", 4)}, RECIPETABS.SHADOWTAB, {MAGIC = 2} )

	local nightlightrecipe = GLOBAL.Recipe( ("nightlight"), {Ingredient("goldnugget", 8), Ingredient("nightmarefuel", 2), Ingredient("redgem", 1)}, RECIPETABS.SHADOWTAB, {MAGIC = 2}, "nightlight_placer" )
	local researchlab3recipe = GLOBAL.Recipe( ("researchlab3"), {Ingredient("livinglog", 3), Ingredient("purplegem", 1), Ingredient("nightmarefuel", 7)}, RECIPETABS.MAGIC, {MAGIC = 2}, "researchlab3_placer" )
	
	local nightmarebrickrecipe = GLOBAL.Recipe( ("nightmarebrick"), {Ingredient("nightmarefuel", 6), Ingredient("cutstone", 1)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmarebrickrecipe.atlas = "images/inventoryimages/nightmarebrick.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMAREBRICK = "Solid agony."
	
	local night_swordrecipe = GLOBAL.Recipe( ("nightsword"), {Ingredient("nightmarefuel", 5), Ingredient("livinglog", 1)}, RECIPETABS.SHADOWTAB,  {MAGIC = 3} )
	local armor_sanityrecipe = GLOBAL.Recipe( ("armor_sanity"), {Ingredient("nightmarefuel", 5), Ingredient("papyrus", 3)}, RECIPETABS.SHADOWTAB,  {MAGIC = 3} )

	local nightmarehelmetrecipe = GLOBAL.Recipe( ("nightmarehelmet"), {Ingredient("feather_crow", 6), Ingredient("nightmarefuel", 6), Ingredient("purplegem", 1)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmarehelmetrecipe.atlas = "images/inventoryimages/nightmarehelmet.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMAREHELMET = "Dream your enemies dead."
	
	local dug_nightmare_bushrecipe = GLOBAL.Recipe( ("dug_nightmare_bush"), {Ingredient("nightmarefuel", 7), Ingredient("twigs", 5)}, RECIPETABS.SHADOWTAB,  {MAGIC = 3} )
		dug_nightmare_bushrecipe.atlas = "images/inventoryimages/dug_nightmare_bush.xml"
			GLOBAL.STRINGS.RECIPE_DESC.DUG_NIGHTMARE_BUSH = "For farming nightmares."
		
	local nightmareaxerecipe = GLOBAL.Recipe( ("nightmareaxe"), {Ingredient("nightmarefuel", 5), Ingredient("twigs", 4), Ingredient("goldnugget", 2)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmareaxerecipe.atlas = "images/inventoryimages/nightmareaxe.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMAREAXE = "Give the trees nightmares."
			
	local nightmarepickaxerecipe = GLOBAL.Recipe( ("nightmarepickaxe"), {Ingredient("nightmarefuel", 5), Ingredient("twigs", 4), Ingredient("goldnugget", 2)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmarepickaxerecipe.atlas = "images/inventoryimages/nightmarepickaxe.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMAREPICKAXE = "Use your dreams to break rocks."
			
	local nightmareshovelrecipe = GLOBAL.Recipe( ("nightmareshovel"), {Ingredient("nightmarefuel", 5), Ingredient("twigs", 4), Ingredient("goldnugget", 2)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmareshovelrecipe.atlas = "images/inventoryimages/nightmareshovel.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMARESHOVEL = "Dig dark holes."
			
	local nightmarehammerrecipe = GLOBAL.Recipe( ("nightmarehammer"), {Ingredient("twigs", 3), nightmarebrick, Ingredient("rope", 2)}, RECIPETABS.SHADOWTAB, {MAGIC = 3} )
		nightmarehammerrecipe.atlas = "images/inventoryimages/nightmarehammer.xml"
			GLOBAL.STRINGS.RECIPE_DESC.NIGHTMAREHAMMER = "Smash stuff with insanity."
			
	local wall_nightmare_itemrecipe = GLOBAL.Recipe( ("wall_nightmare_item"), {nightmarebrickthree}, RECIPETABS.SHADOWTAB, {MAGIC = 3},nil,nil,nil,6 )
		wall_nightmare_itemrecipe.atlas = "images/inventoryimages/wall_nightmare_item.xml"
			GLOBAL.STRINGS.RECIPE_DESC.WALL_NIGHTMARE_ITEM = "Protect yourself with your own nightmares."
 

for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do 
if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "Wall Gates" then 
 
 local mech_nightmare_itemrecipe = GLOBAL.Recipe( ("mech_nightmare_item"), {nightmarewall, Ingredient("goldnugget", 2), Ingredient("gears", 1)}, RECIPETABS.SHADOWTAB, {MAGIC = 3},nil,nil,nil,1 )
		mech_nightmare_itemrecipe.atlas = "images/inventoryimages/mech_nightmare_item.xml"
			GLOBAL.STRINGS.RECIPE_DESC.MECH_NIGHTMARE_ITEM = "Enter and exit your base of evil."
			
			GLOBAL.STRINGS.NAMES.MECH_NIGHTMARE_ITEM = "Nightmare Wall Gate"
			GLOBAL.STRINGS.NAMES.MECH_NIGHTMARE = "Nightmare Wall Gate"
			
			GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_NIGHTMARE_ITEM = "This isn't so light..."
			GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_NIGHTMARE = "My nightmares can keep out reality!"
			
			GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_NIGHTMARE_ITEM = "It's like a door, except I can't burn it down."
			GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_NIGHTMARE = "I can't believe I'm going through with this."
			
			GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_NIGHTMARE_ITEM = "Is fancy scary door-wall!"
			GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_NIGHTMARE = "Gate is scary, not mighty."
			
			GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_NIGHTMARE_ITEM = "My castle is not complete without a gate. And a moat."
			GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_NIGHTMARE = "Now my isolation is complete."
			
			GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_NIGHTMARE_ITEM = "A PRIMITIVE, YET EFFECTIVE ENTRY SYSTEM."
			GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_NIGHTMARE = "A FEARSOME DEFENSE."
			
			GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_NIGHTMARE_ITEM = "I'm starting to question myself, to be honest."
			GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_NIGHTMARE = "Voila! I have conquered this substance!"
			
			GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_NIGHTMARE_ITEM = "This kind of stuff isn't my thing. \n I'm sure Lucy doesn't approve, either."
			GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_NIGHTMARE = "Just touching it makes me question myself, eh?"
			
			GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_NIGHTMARE_ITEM = "Before long, it'll feel just like home."
			GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_NIGHTMARE = "I have almost everything I could ask for, now."
end 
end 

AddSimPostInit(function(inst)
--local easing = require("easing")
--self = GetPlayer().components.sanity

--Tables
local NightmareTable =
{
"statue_transition",
"statue_transition_2",
}

local NightmareTableTwo = 
{
"crawlingnightmare",
"nightmarebatt",
"nightmarebug",
"nightmarespider",
}

local NightmareTableThree =
{
"nightmarebeak",
"rocknightmare",
"nightmareman",
"nightmarewarlock",
}
	
	  --Change State
		inst:DoPeriodicTask(0.01, function()
		if inst.prefab == webber then
			if not inst:HasTag("monster") then
				inst:AddTag("monster")
			end
		end
		
		if inst:HasTag("NightmareOne") and inst:HasTag("NightmareTwo") and inst:HasTag("NightmareThree") then
			inst.AnimState:SetMultColour(0.05, 0.05, 0.05, 0.5)
			inst:AddTag("monster")
			if not (inst:HasTag("fakeinsane")) then
			inst:AddTag("fakeinsane")
			end
			else
			inst.AnimState:SetMultColour(1, 1, 1, 1)
			inst:RemoveTag("monster")
			if (inst:HasTag("fakeinsane")) then
			inst:RemoveTag("fakeinsane")
			end
		end
	end)
	
	--Periodic Spawners
	inst:DoPeriodicTask(math.random(3,8), function()
	local theta = math.random() * 2 * GLOBAL.PI
    local pt = inst:GetPosition()
    local radius = math.random(5, 10)
    local offset = GLOBAL.FindWalkableOffset(pt, theta, radius, 12, true)
	
	local theta2 = math.random() * 2 * GLOBAL.PI
    local pt2 = inst:GetPosition()
    local radius2 = math.random(30, 40)
    local offset2 = GLOBAL.FindWalkableOffset(pt2, theta2, radius2, 12, true)
	
	local SpawnSomeCrapOne = math.random(1,2)
    local SpawnSomeCrapTwo = math.random(1,20)
    local SpawnSomeCrapThree = math.random(1,25)
    local SpawnSomeCrapFour = math.random(1,30)
	if (inst:HasTag("fakeinsane")) then
		print("SPAWNSTART")
		if SpawnSomeCrapOne == 2 then
		if offset then
		local NightmarespawnerOne = GLOBAL.SpawnPrefab(GLOBAL.GetRandomItem(NightmareTable))
		local pos = pt + offset
		NightmarespawnerOne.Transform:SetPosition(pos:Get())
		end
		print("effect")
		end
		if SpawnSomeCrapTwo == 20 then
		if offset2 then
		local NightmarespawnerTwo = GLOBAL.SpawnPrefab(GLOBAL.GetRandomItem(NightmareTableTwo))
		local pos2 = pt + offset
		NightmarespawnerTwo.Transform:SetPosition(pos2:Get())
		end
		print("tableone")
		end
		if SpawnSomeCrapThree == 25 then
		if offset2 then
		local NightmarespawnerThree = GLOBAL.SpawnPrefab(GLOBAL.GetRandomItem(NightmareTableThree))
		local pos2 = pt + offset
		NightmarespawnerThree.Transform:SetPosition(pos2:Get())
		end
		print ("tabletwo")
		end
		if SpawnSomeCrapFour == 30 then
		SpawnPrefab("nightmarefuel").Transform:SetPosition(inst:GetPosition():Get())
		print ("nightmarepoop")
		end
	end
	end)
end)

AddPrefabPostInit("nightsword", function(inst)
    inst.components.weapon.onattack = function(inst, owner, target)
    SpawnPrefab("statue_transition").Transform:SetPosition(target:GetPosition():Get())
end
end)

AddPrefabPostInit("nightmarefuel", function(inst)
	inst:AddComponent("repairer")
	inst.components.repairer.repairmaterial = "nightmares"
	inst.components.repairer.healthrepairvalue = 25
end)

--Names
GLOBAL.STRINGS.NAMES.NIGHTMARE_BUSH = "Nightmare Bush"
GLOBAL.STRINGS.NAMES.DUG_NIGHTMARE_BUSH = "Nightmare Bush"
GLOBAL.STRINGS.NAMES.NIGHTMAREAXE = "Nightmare Axe"
GLOBAL.STRINGS.NAMES.NIGHTMAREPICKAXE = "Nightmare Pickaxe"
GLOBAL.STRINGS.NAMES.NIGHTMARESHOVEL = "Nightmare Shovel"
GLOBAL.STRINGS.NAMES.NIGHTMAREBRICK = "Nightmare Brick"
GLOBAL.STRINGS.NAMES.WALL_NIGHTMARE_ITEM = "Nightmare Wall"
GLOBAL.STRINGS.NAMES.WALL_NIGHTMARE = "Nightmare Wall"
GLOBAL.STRINGS.NAMES.NIGHTMAREHAMMER = "Nightmare Hammer"
GLOBAL.STRINGS.NAMES.NIGHTMAREHELMET = "Murder Crown"
GLOBAL.STRINGS.NAMES.HORRIDBATT = "Fright Wing"
GLOBAL.STRINGS.NAMES.WRETCHEDROCK = "Wretched Rock"
GLOBAL.STRINGS.NAMES.SHADOWBUG = "Prickly Pestilence"
GLOBAL.STRINGS.NAMES.SCARYSPIDER = "Loathsome Leaper"
GLOBAL.STRINGS.NAMES.CREEPYMAN = "Dusk Stalker"
GLOBAL.STRINGS.NAMES.WICKEDWARLOCK = "Wicked Warlock"
GLOBAL.STRINGS.NAMES.NIGHTMAREBATT = "Fright Wing"
GLOBAL.STRINGS.NAMES.ROCKNIGHTMARE = "Wretched Rock"
GLOBAL.STRINGS.NAMES.NIGHTMAREBUG = "Prickly Pestilence"
GLOBAL.STRINGS.NAMES.NIGHTMARESPIDER = "Loathsome Leaper"
GLOBAL.STRINGS.NAMES.NIGHTMAREMAN = "Dusk Stalker"
GLOBAL.STRINGS.NAMES.NIGHTMAREWARLOCK = "Wicked Warlock"

		--Wilson & mod characters that don't have lines written
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.DUG_NIGHTMARE_BUSH = "It's unnatural. This seems wrong."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = " I dreamt this would happen.",
																		BURNING = "My dreams are going up in flames!",
																		PICKED = "Some things just aren't worth exploring.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMAREAXE = "Axe me how I feel about this later."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMAREPICKAXE = "It's benign, at least."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARESHOVEL = "Perfect for digging some dark holes."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMAREHAMMER = "Now I need some dark nails to hammer."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMAREHELMET = "Wearing it makes my head hurt."
		
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMAREBRICK = "This doesn't make much sense."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.WALL_NIGHTMARE_ITEM = "It's surprisingly light."
		GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.WALL_NIGHTMARE = "It's safe and insecure. Like me."

		--Willow
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.DUG_NIGHTMARE_BUSH = "THIS is why I set things on fire."
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "It'll burn real nice, I bet!",
																		BURNING = "I may love fire, but this fire feels evil.",
																		PICKED = "Can I burn it now?",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMAREAXE = "It needs to be on fire!"
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMAREPICKAXE = "I guess I can't burn rocks, but now I can mine them!"
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMARESHOVEL = "I'd rather burn things than dig them up."
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMAREHAMMER = "I still prefer sharp implements."
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMAREHELMET = "This... seems like a bad idea."
		
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTMAREBRICK = "It's still warm."
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.WALL_NIGHTMARE_ITEM = "I can't burn this...what do I do with it now?"
		GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.WALL_NIGHTMARE = "That's not gonna burn."

		--Wolfgang
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.DUG_NIGHTMARE_BUSH = "Is made of fear!"
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "Bush is scary! Wolfgang hates this bush!",
																		BURNING = "Good, don't have to deal with it now.",
																		PICKED = "Is not scary now.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMAREAXE = "Is scary axe!"
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMAREPICKAXE = "Spooky pick scares Wolfgang."
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMARESHOVEL = "Wolfgang can hear spooky shovel speak to Wolfgang."
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMAREHAMMER = "Something wrong with hammer."
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMAREHELMET = "I do not want to wear this."
		
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTMAREBRICK = "Is spooky smooth rock!"
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.WALL_NIGHTMARE_ITEM = "Where does scary wall go?"
		GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.WALL_NIGHTMARE = "Wall is strong and scary."

		--Wendy
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.DUG_NIGHTMARE_BUSH = "Where shall I sow this evil?"
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "A dark taint rises up from within...",
																		BURNING = "Aflame, like everything else I once held dear.",
																		PICKED = "I must wait for fresh nightmares to grow.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMAREAXE = "Darkness begets death to trees. And man."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMAREPICKAXE = "The power of darkness, chained to a simple task."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMARESHOVEL = "At last, I can dig myself a dark hole to die in."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMAREHAMMER = "A powerful implement to crush the heads of my foes...or buildings."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMAREHELMET = "I shall hide my head behind the darkness of my heart."
		
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTMAREBRICK = "I shall make a house of horrors."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.WALL_NIGHTMARE_ITEM = "And now, I can truly begin to isolate myself."
		GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.WALL_NIGHTMARE = "I shall cut myself off from the outside world."

		--WX78
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.DUG_NIGHTMARE_BUSH = "IT FEEDS ON BAD IDEAS"
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "ITS VERY EXISTENCE IS ILLOGICAL",
																		BURNING = "IT HAS COMBUSTED. I HAVE FAILED.",
																		PICKED = "IT IS DEPLETED.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMAREAXE = "DEFORESTATION POWERED BY FEAR"
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMAREPICKAXE = "THESE FORCES ARE MALLEABLE."
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMARESHOVEL = "A FEAR-FUELED UPROOTING DEVICE."
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMAREHAMMER = "IT CREATES AS MUCH FEAR AS IT NEEDS. I LIKE IT."
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMAREHELMET = "THIS HEADCASE PROTECTOR IS POWERED BY DEBUGGING RESIDUE."
		
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTMAREBRICK = "SOLIDIFIED DESPAIR."
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.WALL_NIGHTMARE_ITEM = "READY FOR CONSTRUCTION."
		GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.WALL_NIGHTMARE = "A WALL OF SOLID AGONY."

		--Wickerbottom
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.DUG_NIGHTMARE_BUSH = "At last, a source of nightmares that doesn't involve sleep."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "I'm not much for gardening, dearie.",
																		BURNING = "It's not going to be making any evil like that.",
																		PICKED = "I'll be needing more for my research.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMAREAXE = "This would tear a man asunder just as well as chop a tree."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMAREPICKAXE = "This seems rather dangerous."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMARESHOVEL = "Magic and science meshing together!"
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMAREHAMMER = "Sometimes, a more direct approach is needed."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMAREHELMET = "Nothing ventured, nothing gained."
		
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTMAREBRICK = "A mentally unsound building material."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.WALL_NIGHTMARE_ITEM = "I'll never figure out why I can carry so many of these."
		GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.WALL_NIGHTMARE = "A construct of magic twisted by science."

		--Woodie
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.DUG_NIGHTMARE_BUSH = "They never had nightmares like this back where I came from."
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "I'm suddenly feeling less polite.",
																		BURNING = "I see all the wrongs I've committed, in that burning bush.",
																		PICKED = "It's... growing... darkness.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMAREAXE = "I hope Lucy won't be mad at me."
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMAREPICKAXE = "I'm not so sure how I feel about this."
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMARESHOVEL = "I wonder what else I could make with this stuff, eh?"
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMAREHAMMER = "I'm not feeling so polite anymore."
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMAREHELMET = "This doesn't seem like a good idea."
		
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTMAREBRICK = "I wouldn't dare sleep in a house made of this stuff."
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.WALL_NIGHTMARE_ITEM = "Now what?"
		GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.WALL_NIGHTMARE = "This just isn't right to me."

		--Maxwell
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.DUG_NIGHTMARE_BUSH = "We're treading a fine line, here."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "'Make a bush out of the fuel', they said...",
																		BURNING = "In retrospect, all of this was preventable.",
																		PICKED = "It is spent, for now.",
																	}
		
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMAREAXE = "So many of my creations should've gotten the axe."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMAREPICKAXE = "The fuel works well to split the rock."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMARESHOVEL = "I imagine They don't like this in the least."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMAREHAMMER = "It isn't my forte. I thought this had been made clear before."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMAREHELMET = "If I have to embrace Them, then I will."
		
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTMAREBRICK = "Better than actual bricks."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.WALL_NIGHTMARE_ITEM = "The pieces stick to my hands."
		GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.WALL_NIGHTMARE = "It almost feels like home."
		
		--Dusk Stalker lines
		STRINGS.DUSKSTALKER_LINES = {}
		STRINGS.DUSKSTALKER_LINES_TWO = {}
		STRINGS.DUSKSTALKER_LINES_THREE = {}
		STRINGS.DUSKSTALKER_LINES_FOUR = {}
		STRINGS.DUSKSTALKER_LINES_FIVE = {}
		STRINGS.DUSKSTALKER_LINES.TALKTOMODDED = "buddy"
		
		STRINGS.DUSKSTALKER_LINES.wilson = "Was it worth throwing your life away, Wilson?"
		STRINGS.DUSKSTALKER_LINES_TWO.wilson = "Your mind is growing weak, Higgsbury. Can you see the folly of your science?"
		STRINGS.DUSKSTALKER_LINES_THREE.wilson = "Science won't save you now."
		STRINGS.DUSKSTALKER_LINES_FOUR.wilson = "Do you really think you can still conquer this place with your mind?"
		STRINGS.DUSKSTALKER_LINES_FIVE.wilson = "The flesh wants to submit. Will your mind finally surrender, and face the truth?"
		
		STRINGS.DUSKSTALKER_LINES.willow = "All fires die out eventually, Willow."
		STRINGS.DUSKSTALKER_LINES_TWO.willow = "All fires die out eventually, Willow."
		STRINGS.DUSKSTALKER_LINES_THREE.willow = "All fires die out eventually, Willow."
		STRINGS.DUSKSTALKER_LINES_FOUR.willow = "All fires die out eventually, Willow."
		STRINGS.DUSKSTALKER_LINES_FIVE.willow = "All fires die out eventually, Willow."
		
		STRINGS.DUSKSTALKER_LINES.wolfgang = "Even your own muscles will turn against you in time, Wolfgang."
		STRINGS.DUSKSTALKER_LINES_TWO.wolfgang = "Even your own muscles will turn against you in time, Wolfgang."
		STRINGS.DUSKSTALKER_LINES_THREE.wolfgang = "Even your own muscles will turn against you in time, Wolfgang."
		STRINGS.DUSKSTALKER_LINES_FOUR.wolfgang = "Even your own muscles will turn against you in time, Wolfgang."
		STRINGS.DUSKSTALKER_LINES_FIVE.wolfgang = "Even your own muscles will turn against you in time, Wolfgang."
		
		STRINGS.DUSKSTALKER_LINES.wendy = "If Abigail could speak, she would cry for you."
		STRINGS.DUSKSTALKER_LINES_TWO.wendy = "If Abigail could speak, she would cry for you."
		STRINGS.DUSKSTALKER_LINES_THREE.wendy = "If Abigail could speak, she would cry for you."
		STRINGS.DUSKSTALKER_LINES_FOUR.wendy = "If Abigail could speak, she would cry for you."
		STRINGS.DUSKSTALKER_LINES_FIVE.wendy = "If Abigail could speak, she would cry for you."
		
		STRINGS.DUSKSTALKER_LINES.wx78 = "Ashes to ashes... rust to rust."
		STRINGS.DUSKSTALKER_LINES_TWO.wx78 = "Ashes to ashes... rust to rust."
		STRINGS.DUSKSTALKER_LINES_THREE.wx78 = "Ashes to ashes... rust to rust."
		STRINGS.DUSKSTALKER_LINES_FOUR.wx78 = "Ashes to ashes... rust to rust."
		STRINGS.DUSKSTALKER_LINES_FIVE.wx78 = "Ashes to ashes... rust to rust."
		
		STRINGS.DUSKSTALKER_LINES.wickerbottom = "Knowledge like the kind you seek will rot your mind, Ms. Wickerbottom."
		STRINGS.DUSKSTALKER_LINES_TWO.wickerbottom = "Knowledge like the kind you seek will rot your mind, Ms. Wickerbottom."
		STRINGS.DUSKSTALKER_LINES_THREE.wickerbottom = "Knowledge like the kind you seek will rot your mind, Ms. Wickerbottom."
		STRINGS.DUSKSTALKER_LINES_FOUR.wickerbottom = "Knowledge like the kind you seek will rot your mind, Ms. Wickerbottom."
		STRINGS.DUSKSTALKER_LINES_FIVE.wickerbottom = "Knowledge like the kind you seek will rot your mind, Ms. Wickerbottom."
		
		STRINGS.DUSKSTALKER_LINES.woodie = "I wonder if that axe of yours can float!"
		STRINGS.DUSKSTALKER_LINES_TWO.woodie = "I wonder if that axe of yours can float!"
		STRINGS.DUSKSTALKER_LINES_THREE.woodie = "I wonder if that axe of yours can float!"
		STRINGS.DUSKSTALKER_LINES_FOUR.woodie = "I wonder if that axe of yours can float!"
		STRINGS.DUSKSTALKER_LINES_FIVE.woodie = "I wonder if that axe of yours can float!"
		
		STRINGS.DUSKSTALKER_LINES.wes = "Y'know... Most of the world hates mimes..."
		STRINGS.DUSKSTALKER_LINES_TWO.wes = "Y'know... Most of the world hates mimes..."
		STRINGS.DUSKSTALKER_LINES_THREE.wes = "Y'know... Most of the world hates mimes..."
		STRINGS.DUSKSTALKER_LINES_FOUR.wes = "Y'know... Most of the world hates mimes..."
		STRINGS.DUSKSTALKER_LINES_FIVE.wes = "Y'know... Most of the world hates mimes..."
		
		STRINGS.DUSKSTALKER_LINES.waxwell = "William... Charlie... she BURNS... is this not your fault?"
		STRINGS.DUSKSTALKER_LINES_TWO.waxwell = "William... Charlie... she BURNS... is this not your fault?"
		STRINGS.DUSKSTALKER_LINES_THREE.waxwell = "William... Charlie... she BURNS... is this not your fault?"
		STRINGS.DUSKSTALKER_LINES_FOUR.waxwell = "William... Charlie... she BURNS... is this not your fault?"
		STRINGS.DUSKSTALKER_LINES_FIVE.waxwell = "William... Charlie... she BURNS... is this not your fault?"
		
		STRINGS.DUSKSTALKER_LINES.wathgrithr = "How long will you keep up this act, Wigfrid?"
		STRINGS.DUSKSTALKER_LINES_TWO.wathgrithr = "How long will you keep up this act, Wigfrid?"
		STRINGS.DUSKSTALKER_LINES_THREE.wathgrithr = "How long will you keep up this act, Wigfrid?"
		STRINGS.DUSKSTALKER_LINES_FOUR.wathgrithr = "How long will you keep up this act, Wigfrid?"
		STRINGS.DUSKSTALKER_LINES_FIVE.wathgrithr = "How long will you keep up this act, Wigfrid?"
		
		STRINGS.DUSKSTALKER_LINES.webber = "You will never fit in with them, Webber."
		STRINGS.DUSKSTALKER_LINES_TWO.webber = "You will never fit in with them, Webber."
		STRINGS.DUSKSTALKER_LINES_THREE.webber = "You will never fit in with them, Webber."
		STRINGS.DUSKSTALKER_LINES_FOUR.webber = "You will never fit in with them, Webber."
		STRINGS.DUSKSTALKER_LINES_FIVE.webber = "You will never fit in with them, Webber."
		
		STRINGS.DUSKSTALKER_LINES.GENERIC = "I'm not quite sure what to tell you..."
		STRINGS.DUSKSTALKER_LINES_TWO.GENERIC = "I don't know what to say..."
		STRINGS.DUSKSTALKER_LINES_THREE.GENERIC = "You've put me at loss for words..."
		STRINGS.DUSKSTALKER_LINES_FOUR.GENERIC = "I am completely speechless..."
		STRINGS.DUSKSTALKER_LINES_FIVE.GENERIC = "Who are you?"

AddSimPostInit(function(inst)

		--Wigfrid
        if inst.prefab == "wathgrithr" then
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.DUG_NIGHTMARE_BUSH = "The dark elves have been busy."
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "I have taken the spoils of the dark evil!",
																		BURNING = "Sent back to the firey pits of Hell!",
																		PICKED = "Evil should not be left to fester, but pulled out at the root!",
																	}
		
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMAREAXE = "A power most foul indeed lies within this simple tool!"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMAREPICKAXE = "It is the slave, not I!"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMARESHOVEL = "It is corrupted by a force most putrid!"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMAREHAMMER = "A smith would use this to create only the strongest of equipment."
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMAREHELMET = "A mighty hat for a dark power!"
		
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.NIGHTMAREBRICK = "The cornerstone of a dark fortress."
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.WALL_NIGHTMARE_ITEM = "A builder, I am not!"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.WALL_NIGHTMARE = "If I build it, will They come?"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.MECH_NIGHTMARE_ITEM = "And lo! We must storm this castle and vanquish the evil therein!"
		STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.MECH_NIGHTMARE = "The entrance to a place forsaken!"
		
		--Webber
	elseif inst.prefab == "webber" then
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.DUG_NIGHTMARE_BUSH = "We might be losing my mind."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMARE_BUSH = 
																	{
																		GENERIC = "Nothing good can come of this.",
																		BURNING = "He's sad about this, I'm not!",
																		PICKED = "Can't sleep... bush will eat me...",
																	}
		
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMAREAXE = "He likes it. I don't."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMAREPICKAXE = "Is it safe?..."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMARESHOVEL = "I can dig darkness!"
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMAREHAMMER = "I'm gonna smash it!"
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMAREHELMET = "It barely fits me."
		
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.NIGHTMAREBRICK = "I wouldn't mind making a home out of this."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.WALL_NIGHTMARE_ITEM = "It feels weird. I hope I'm not making a mistake."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.WALL_NIGHTMARE = "It's both disturbing and comforting."
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.MECH_NIGHTMARE_ITEM = "This will be the entrance. Where to put it?"
		STRINGS.CHARACTERS.WEBBER.DESCRIBE.MECH_NIGHTMARE = "I guess that'll do."
        end
end)

	--The New Recipes

STRINGS.RECIPE_DESC.BLUEGEM = "Brilliantly blue." 
Recipe("bluegem", {Ingredient("ice",2), Ingredient("nightmarefuel",3), Ingredient("feather_robin_winter",2)}, RECIPETABS.SHADOWTAB,  TECH.MAGIC_TWO)


STRINGS.RECIPE_DESC.REDGEM = "Ravashingly red." 
Recipe("redgem", {Ingredient("charcoal",2), Ingredient("nightmarefuel",3), Ingredient("feather_robin",2)}, RECIPETABS.SHADOWTAB,  TECH.MAGIC_TWO)


STRINGS.RECIPE_DESC.YELLOWGEM = "Yearningly yellow." 
Recipe("yellowgem", {Ingredient("goldnugget",2), Ingredient("nightmarefuel",3), Ingredient("feather_robin_winter",1), Ingredient("feather_robin",1)}, RECIPETABS.SHADOWTAB,  TECH.MAGIC_TWO)


STRINGS.RECIPE_DESC.ORANGEGEM = "Obviously orange." 
Recipe("orangegem", {Ingredient("redgem",1), Ingredient("yellowgem",1)}, RECIPETABS.REFINE,  TECH.MAGIC_THREE)


STRINGS.RECIPE_DESC.GREENGEM = "Grievously green." 
Recipe("greengem", {Ingredient("bluegem",1), Ingredient("yellowgem",1)}, RECIPETABS.REFINE,  TECH.MAGIC_THREE)


STRINGS.RECIPE_DESC.LIVINGLOG = "It stares at you, judges you."
Recipe("livinglog", {Ingredient("log",1), Ingredient("nightmarefuel",1)}, RECIPETABS.SHADOWTAB, TECH.MAGIC_TWO)


STRINGS.RECIPE_DESC.THULECITEPIECES = "Fragments of something."
Recipe("thulecite_pieces", {Ingredient("yellowgem",1), Ingredient("purplegem",1), Ingredient("nightmarefuel",3)}, RECIPETABS.ANCIENT, TECH.ANCIENT_ONE)


	















